@extends('Layouts.serviceDetailLayout')
@section('content')
    <div id="primary" class="content-area col-lg-8 col-md-8 col-sm-12 col-xs-12 pull-right">
        <main id="main" class="site-main">

            <article class="ot_service type-ot_service status-publish has-post-thumbnail hentry">
                <div class="inner-post">
                    <section class="wpb_row row-fluid">
                        <div class="container">
                            <div class="row">
                                <div class="wpb_column column_container col-sm-12">
                                    <div class="column-inner">
                                        <div class="wpb_wrapper">
                                            <h3>Track your items</h3>
                                            <div class="wpb_text_column wpb_content_element">
                                                <div class="wpb_wrapper">
                                                    <div class="text-center">
                                                        <input class="form-control" id="rnumber" placeholder="Reference ID" style="padding:20px 20px; border-radius: 20px;">
                                                        <br><br>
                                                        <button style="padding:20px 20px; border-radius: 20px; width: 170px; background-color: #3e8055; color: white" id="track">Track</button>
                                                        <div class="row" style="padding-top: 20px;" id="itemDetail">

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            {{--<div class="empty_space_30"></div>--}}
                                            {{--<h4>XL Outsourcing eLMS provides the following:</h4>
                                            <div class="wpb_text_column wpb_content_element">
                                                <div class="wpb_wrapper">
                                                    <ul>
                                                        <li>Technology platform for trainers to host their open training courses. Companies can also buy hosting space for internal training needs.</li>
                                                        <li>Curriculum development and training material production (slides and videos) for online training.</li>
                                                        <li>Asynchronous courses: These are static courses, but are hosted on the web.</li>
                                                        <li>Synchronous ones: These are live courses moderated by an instructor / facilitator which includes audio-video conferencing over the Internet.</li>
                                                        <li>Customized content development for specific companies or industries.</li>
                                                    </ul>

                                                </div>
                                            </div>--}}
                                            <div class="empty_space_30"></div>
                                            <h4></h4>

                                            {{--<div class="empty_space_45"></div>--}}
                                            {{--<h4>Want to have a glimpse of our LMS solution</h4>
                                            <div class="wpb_text_column wpb_content_element">
                                                <div class="wpb_wrapper">
                                                    <p><a class="btn btn-danger">Check it out</a></p>
                                                </div>
                                            </div>--}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </article>

        </main>
        <!-- #main -->
    </div>
@stop
@section('script')
    <script>


        document.getElementById('track').onclick = function () {
            var refnumber = document.getElementById('rnumber').value
            if(refnumber !="" && refnumber !=null){
                document.getElementById('track').innerHTML = "Tracking...";
                document.getElementById('track').setAttribute('disabled', 'disabled');
                document.getElementById('track').setAttribute('style', "opacity: 0.5; padding:20px 20px; border-radius: 20px; width: 170px; background-color: #3e8055; color: white");

                jQuery.ajax({
                    url: "https://api.xlexpressandlogistics.com/api/track/"+refnumber,
                    method : 'GET',
                    crossDomain: true,
                    beforeSend: function(xhr){
                        xhr.withCredentials = true;
                    },
                    success: function (data) {
                        console.log(data);
                        document.getElementById('track').removeAttribute('disabled');
                        document.getElementById('track').setAttribute('style', "opacity: 1.0; padding:20px 20px; border-radius: 20px; width: 170px; background-color: #3e8055; color: white");
                        document.getElementById('track').innerHTML = "Track";
                        if (data.status) {
                            var stat = data.items[0].delivery_status
                            var aggr = ((stat+1)/4)*100
                            if(aggr == 25){
                                document.getElementById('itemDetail').innerHTML = '<p style="color: #205a24">'+data.message+'</p><p style="font-size: 50px;">'+ aggr +'% complete</p><p>You have successfully made your request and it is being attended to.</p>'
                            }else if(aggr == 50){
                                document.getElementById('itemDetail').innerHTML = '<p style="color: #205a24">'+data.message+'</p><p style="font-size: 50px;">'+ aggr +'% complete</p><p>Your item(s) now at our hub. A rider will be assigned to deliver it soonest.</p>'
                            }else if(aggr == 75){
                                document.getElementById('itemDetail').innerHTML = '<p style="color: #205a24">'+data.message+'</p><p style="font-size: 50px;">'+ aggr +'% complete</p><p>A rider is now delivering your item</p>'
                            }else if(aggr ==100){
                                document.getElementById('itemDetail').innerHTML = '<p style="color: #205a24">'+data.message+'</p><p style="font-size: 50px;">'+ aggr +'% complete</p><p>Your item(s) have been deliver</p>'
                            }

                        }else{
                            document.getElementById('itemDetail').innerHTML = '<p style="color: red">'+data.message+'</p>'
                        }
                        window.scrollTo(0, 400);
                    }
                });
            }else{
                document.getElementById('itemDetail').innerHTML = '<p style="color: red">The reference ID for the item(s) is not provided.</p>'
            }
        }

    </script>
@stop