<?php

namespace App\Http\Controllers;

//use App\Mail\contactForm;
//use App\Mail\requestCallBack;
//use App\newsletter_subscription;
use App\Mail\contactForm;
use App\Mail\requestCallBack;
use App\newsletter_subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class pagesController extends Controller
{
    /*function index(){
        $title = "XL Outsourcing - Home";
        return view('index', ['title'=>$title]);
    }*/

    function about(){
        $identifier = "About Us";
        $title = "XL Express and Logistics Limited - About";
        return view('about', ['title'=>$title, 'identifier' => $identifier]);
    }

    function mailroom(){
        $identifier = "Mail Room Management";
        $title = "XL Express and Logistics Limited | Mail Room Management | Mail Room Management in Nigeria";
        return view('mailroom', ['title'=>$title, 'identifier' => $identifier]);
    }

    function courier(){
        $identifier = "Express Mail & Courier Services";
        $title = "XL Express and Logistics Limited | Express Mail & Courier Services in Nigeria";
        return view('courier', ['title'=>$title, 'identifier' => $identifier]);
    }

    function forwarding(){
        $identifier = "Cargo clearing and Forwarding";
        $title = "XL Express and Logistics Limited | Delivery Companies in Nigeria | Cargo clearing and Forwarding in Nigeria";
        return view('forwarding', ['title'=>$title, 'identifier' => $identifier]);
    }

    function mailDelivery(){
        $identifier = "Bulk Mail Deliveries";
        $title = "XL Express and Logistics Limited | Courier Company | Bul Mail Delivery Company in Nigeria";
        return view('mailDelivery', ['title'=>$title, 'identifier' => $identifier]);
    }

    function haulage(){
        $identifier = "Haulage";
        $title = "XL Express and Logistics Limited | Haulage | Mail Room Management";
        return view('haulage', ['title'=>$title, 'identifier' => $identifier]);
    }

    function contact(){
        $identifier = "Contact Us";
        $title = "XL Express and Logistics Limited | Contact | Logistics | Courier company";
        return view('contact', ['title'=>$title, 'identifier' => $identifier]);
    }

    function team(){
        $identifier = "Our Team";
        $title = "XL Express and Logistics Limited | Team | Courier Services| Logistics services  in nigeria";
        return view('team', ['title'=>$title, 'identifier' => $identifier]);
    }

    function termsOfUse(){
        $identifier = "Terms of Use";
        $title = "XL Express and Logistics Limited | Courier Services | Logistics services  in nigeria";
        return view('termsOfUse', ['title'=>$title, 'identifier' => $identifier]);
    }



    function requestCallBack(Request $request){
//        return $request;
        try{
            Mail::to(['o.madu@xlafricagroup.com'])->send(new requestCallBack($request->all()));
            return response()->json(['success'=>'request sent']);
        }catch (\Exception $e){
            return $e->getMessage();
        }

    }

    function subscribe($name, $email){

        try{
            $exist = newsletter_subscription::find($email);
            if($exist != null){
                return response()->json(['error'=>'You already subscribed'], 200);
            }
            if($name == null && $email == null){
                return response()->json(['error'=>'Something went wrong'], 200);
            }
            $newslatter = new newsletter_subscription();
            $newslatter->name = $name;
            $newslatter->email = $email;
            $newslatter->save();
            return response()->json(['success'=>'You have been successfully subscribed']);
        }catch (\Exception $e){
            return $e->getMessage();
        }
    }

    function contactSiteOwner(Request $request){
        try{
            Mail::to('a.ajibade@xlafricagroup.com')->cc(['o.madu@xlafricagroup.com'])->send(new contactForm($request->all()));
            return response()->json(['success'=>'Request sent']);
        }catch (\Exception $e){
            return $e->getMessage();
        }
    }

    function track(){
        $identifier = "Track";
        return view('track', ['identifier' => $identifier]);
    }
}
